<?php
abstract class DBConnection extends PDO {
  static public function getInstance($name = null)
  {
    // Pobranie najnowszej statycznie wiązanej wersji __CLASS__
    $class = get_called_class();

    // Możliwość przekazania nazwy, w celu utworzenia wielu egzemplarzy
    // Jeśli nie zostanie podana nazwa, będzie działać jak singleton
    $name = (!is_null($name)) ?: $class;
    if (!Registry::contains($name)) {
      $instance = new $class();
      Registry::add($instance, $name);
    }
    return Registry::get($name);
  }
}

class DBWriteConnection extends DBConnection {
  private function __construct()
  {
     parent::__construct(APP_DB_WRITE_DSN, APP_DB_WRITE_USER, APP_DB_WRITE_PASSWORD);
  }
}

class DBReadConnection extends DBConnection {
  private function __construct()
  {
     parent::__construct(APP_DB_READ_DSN, APP_DB_READ_USER, APP_DB_READ_PASSWORD);
  }
}
?>